{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

{ ActiveX / OLE 2 Interface Unit }

unit Borland.Vcl.ActiveX platform;

interface

uses System.Runtime.InteropServices,
  Messages, Windows;

{ Do not WEAKPACKAGE this unit.
  This unit requires startup code to initialize constants. }

const

{ from WTYPES.H }
  MEMCTX_TASK      = 1;
  MEMCTX_SHARED    = 2;
  MEMCTX_MACSYSTEM = 3;
  MEMCTX_UNKNOWN   = -1;
  MEMCTX_SAME      = -2;

  ROTFLAGS_REGISTRATIONKEEPSALIVE = 1;
  ROTFLAGS_ALLOWANYCLIENT         = 2;

  CLSCTX_INPROC_SERVER     = 1;
  CLSCTX_INPROC_HANDLER    = 2;
  CLSCTX_LOCAL_SERVER      = 4;
  CLSCTX_INPROC_SERVER16   = 8;
  CLSCTX_REMOTE_SERVER     = $10;
  CLSCTX_INPROC_HANDLER16  = $20;
  CLSCTX_INPROC_SERVERX86  = $40;
  CLSCTX_INPROC_HANDLERX86 = $80;

{ from OBJBASE }
  CLSCTX_ALL    = CLSCTX_INPROC_SERVER or CLSCTX_INPROC_HANDLER or
      CLSCTX_LOCAL_SERVER;
  CLSCTX_INPROC = CLSCTX_INPROC_SERVER or CLSCTX_INPROC_HANDLER;
  CLSCTX_SERVER = CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER;

  COM_RIGHTS_EXECUTE = 1;
  STGTY_STORAGE   = 1;
  STGTY_STREAM    = 2;
  STGTY_LOCKBYTES = 3;
  STGTY_PROPERTY  = 4;

  STREAM_SEEK_SET = 0;
  STREAM_SEEK_CUR = 1;
  STREAM_SEEK_END = 2;

  LOCK_WRITE     = 1;
  LOCK_EXCLUSIVE = 2;
  LOCK_ONLYONCE  = 4;
{ from WTYPES.H }
{ VARENUM usage key,

    [V] - may appear in a VARIANT
    [T] - may appear in a TYPEDESC
    [P] - may appear in an OLE property set
    [S] - may appear in a Safe Array }

  VT_EMPTY           = 0;   { [V]   [P]  nothing                     }
  VT_NULL            = 1;   { [V]        SQL style Null              }
  VT_I2              = 2;   { [V][T][P]  2 byte signed int           }
  VT_I4              = 3;   { [V][T][P]  4 byte signed int           }
  VT_R4              = 4;   { [V][T][P]  4 byte real                 }
  VT_R8              = 5;   { [V][T][P]  8 byte real                 }
  VT_CY              = 6;   { [V][T][P]  currency                    }
  VT_DATE            = 7;   { [V][T][P]  date                        }
  VT_BSTR            = 8;   { [V][T][P]  binary string               }
  VT_DISPATCH        = 9;   { [V][T]     IDispatch FAR*              }
  VT_ERROR           = 10;  { [V][T]     SCODE                       }
  VT_BOOL            = 11;  { [V][T][P]  True=-1, False=0            }
  VT_VARIANT         = 12;  { [V][T][P]  VARIANT FAR*                }
  VT_UNKNOWN         = 13;  { [V][T]     IUnknown FAR*               }
  VT_DECIMAL         = 14;  { [V][T]   [S]  16 byte fixed point      }

  VT_I1              = 16;  {    [T]     signed char                 }
  VT_UI1             = 17;  {    [T]     unsigned char               }
  VT_UI2             = 18;  {    [T]     unsigned short              }
  VT_UI4             = 19;  {    [T]     unsigned long               }
  VT_I8              = 20;  {    [T][P]  signed 64-bit int           }
  VT_UI8             = 21;  {    [T]     unsigned 64-bit int         }
  VT_INT             = 22;  {    [T]     signed machine int          }
  VT_UINT            = 23;  {    [T]     unsigned machine int        }
  VT_VOID            = 24;  {    [T]     C style void                }
  VT_HRESULT         = 25;  {    [T]                                 }
  VT_PTR             = 26;  {    [T]     pointer type                }
  VT_SAFEARRAY       = 27;  {    [T]     (use VT_ARRAY in VARIANT)   }
  VT_CARRAY          = 28;  {    [T]     C style array               }
  VT_USERDEFINED     = 29;  {    [T]     user defined type          }
  VT_LPSTR           = 30;  {    [T][P]  null terminated string      }
  VT_LPWSTR          = 31;  {    [T][P]  wide null terminated string }

  VT_FILETIME        = 64;  {       [P]  FILETIME                    }
  VT_BLOB            = 65;  {       [P]  Length prefixed bytes       }
  VT_STREAM          = 66;  {       [P]  Name of the stream follows  }
  VT_STORAGE         = 67;  {       [P]  Name of the storage follows }
  VT_STREAMED_OBJECT = 68;  {       [P]  Stream contains an object   }
  VT_STORED_OBJECT   = 69;  {       [P]  Storage contains an object  }
  VT_BLOB_OBJECT     = 70;  {       [P]  Blob contains an object     }
  VT_CF              = 71;  {       [P]  Clipboard format            }
  VT_CLSID           = 72;  {       [P]  A Class ID                  }

  VT_VECTOR        = $1000; {       [P]  simple counted array        }
  VT_ARRAY         = $2000; { [V]        SAFEARRAY*                  }
  VT_BYREF         = $4000; { [V]                                    }
  VT_RESERVED      = $8000;
  VT_ILLEGAL       = $ffff;
  VT_ILLEGALMASKED = $0fff;
  VT_TYPEMASK      = $0fff;

{ from OLEIDL.H }

type
  BORDERWIDTHS = TRect;
  TBorderWidths = BORDERWIDTHS;

const
  DROPEFFECT_NONE   = 0;
  DROPEFFECT_COPY   = 1;
  DROPEFFECT_MOVE   = 2;
  DROPEFFECT_LINK   = 4;
  DROPEFFECT_SCROLL = DWORD($80000000);

type
{ 64-bit large integer }

  Largeint = Int64;

type
  //PIID = PGUID;
  TIID = TGUID;

{ Class ID }

  //PCLSID = PGUID;
  TCLSID = TGUID;

  //PCoServerInfo = ^TCoServerInfo;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _COSERVERINFO = record
    dwReserved1: Longint;
    pwszName: string;  { LPWSTR }
    pAuthInfo: IntPtr; { Pointer }
    dwReserved2: Longint;
  end;
  TCoServerInfo = _COSERVERINFO;
  COSERVERINFO = TCoServerInfo;

  //PMultiQI = ^TMultiQI;
  [StructLayout(LayoutKind.Sequential)]
  tagMULTI_QI = record
    IID: IntPtr;  { PIID }
    [MarshalAs(UnmanagedType.IUnknown)]
    Itf: TObject; { IUnknown }
    hr: HRESULT;
  end;
  TMultiQI = tagMULTI_QI;
  MULTI_QI = TMultiQI;


  //PMultiQIArray = ^TMultiQIArray;
  TMultiQIArray = array of TMultiQI;

  PSafeArray = IntPtr; { ^TSafeArray }

  TVarType = Word;

{ IClassFactory interface }
  [ComImport,
  GuidAttribute('00000001-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IClassFactory = interface
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
      [MarshalAs(UnmanagedType.Interface)] out obj): HResult;
    [PreserveSig]
    function LockServer(fLock: BOOL): HResult;
  end;

{ IMalloc interface }

  [ComImport,
  GuidAttribute('00000002-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IMalloc = interface
    function Alloc(cb: Longint): IntPtr;
    function Realloc(pv: IntPtr; cb: Longint): IntPtr;
    procedure Free(pv: IntPtr);
    function GetSize(pv: IntPtr): Longint;
    function DidAlloc(pv: IntPtr): Integer;
    procedure HeapMinimize;
  end;

{ IStream interface }

type
  // Please see the .NET Framework documentation for details on STATSTG
  tagSTATSTG = System.Runtime.InteropServices.STATSTG;
  TStatStg = tagSTATSTG;
  STATSTG = TStatStg;

  // Please see the .NET Framework documentation for details on UCOMIStream
  IStream = System.Runtime.InteropServices.UCOMIStream;

{ IPersist interface }

  [ComImport,
  GuidAttribute('0000010C-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersist = interface
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;
  end;

{ IPersistStream interface }

  [ComImport,
  GuidAttribute('00000109-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IPersistStream = interface { (IPersist) }
    // IPersist
    [PreserveSig]
    function GetClassID(out classID: TCLSID): HResult;

    // IPersistStream
    [PreserveSig]
    function IsDirty: HResult;
    [PreserveSig]
    function Load([in] var stm: IStream): HResult;
    [PreserveSig]
    function Save([in] var stm: IStream; fClearDirty: BOOL): HResult;
    [PreserveSig]
    function GetSizeMax(out cbSize: Largeint): HResult;
  end;

{ IMoniker interface }

  // Please see the Microsoft .NET Framework documentation for details on UCOMIEnumString
  IMoniker = System.Runtime.InteropServices.UCOMIMoniker;

{ IEnumString interface }

type
  // Please see the Microsoft .NET Framework documentation for details on UCOMIEnumString
  IEnumString = System.Runtime.InteropServices.UCOMIEnumString;

{ IEnumFormatEtc interface }

  [StructLayout(LayoutKind.Sequential)]
  tagDVTARGETDEVICE = record
    tdSize: Longint;
    tdDriverNameOffset: Word;
    tdDeviceNameOffset: Word;
    tdPortNameOffset: Word;
    tdExtDevmodeOffset: Word;
    tdData: THandle; { record end }
  end;
  TDVTargetDevice = tagDVTARGETDEVICE;
  DVTARGETDEVICE = TDVTargetDevice;

  TClipFormat = Word;

  [StructLayout(LayoutKind.Sequential)]
  tagFORMATETC = record
    cfFormat: TClipFormat;
    ptd: IntPtr; { PDVTargetDevice }
    dwAspect: Longint;
    lindex: Longint;
    tymed: Longint;
  end;
  TFormatEtc = tagFORMATETC;
  FORMATETC = TFormatEtc;


  [ComImport,
  GuidAttribute('00000103-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumFORMATETC = interface
    [PreserveSig]
    function Next(celt: ULONG;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of IntPtr; out pceltFetched: ULONG): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumFormatEtc): HResult;
  end;

{ IEnumStatData interface }

  tagSTATDATA = record
    formatetc: TFormatEtc;
    advf: Longint;
    [MarshalAs(UnmanagedType.Interface)]
    advSink: TObject; { IAdviseSink }
    dwConnection: Longint;
  end;
  TStatData = tagSTATDATA;
  STATDATA = TStatData;


  [ComImport,
  GuidAttribute('00000105-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumSTATDATA = interface
    [PreserveSig]
    function Next(celt: ULONG;
      [out, MarshalAs(UnmanagedType.LPArray, SizeParamIndex = 0)]
      rgelt: array of IntPtr; out pceltFetched: ULONG): HResult;
    [PreserveSig]
    function Skip(celt: Longint): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out Enum: IEnumStatData): HResult;
  end;

{ IAdviseSink interface }

  tagSTGMEDIUM = record
    tymed: Longint;
    case Integer of
      0: (hBitmap: HBitmap; unkForRelease: IntPtr); { IUnknown }
      1: (hMetaFilePict: THandle);
      2: (hEnhMetaFile: THandle);
      3: (hGlobal: HGlobal);
      4: (lpszFileName: IntPtr);                    { POleStr }
      5: (stm: IntPtr);                             { IStream }
      6: (stg: intPtr);                             { IStorage }
  end;
  TStgMedium = tagSTGMEDIUM;
  STGMEDIUM = TStgMedium;


  [ComImport,
  GuidAttribute('0000010F-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IAdviseSink = interface
    [PreserveSig]
    procedure OnDataChange([in] var formatetc: TFormatEtc; [in] var stgmed: TStgMedium);
    [PreserveSig]
    procedure OnViewChange(dwAspect: Longint; lindex: Longint);
    [PreserveSig]
    procedure OnRename([in] var mk: IMoniker);
    [PreserveSig]
    procedure OnSave;
    [PreserveSig]
    procedure OnClose;
  end;

{ IDataObject interface }

  [ComImport,
  GuidAttribute('0000010E-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IDataObject = interface
    [PreserveSig]
    function GetData([in] var formatetcIn: TFormatEtc; out medium: TStgMedium): HResult;
    [PreserveSig]
    function GetDataHere([in] var formatetc: TFormatEtc; out medium: TStgMedium): HResult;
    [PreserveSig]
    function QueryGetData([in] var formatetc: TFormatEtc): HResult;
    [PreserveSig]
    function GetCanonicalFormatEtc([in] var formatetc: TFormatEtc;
      out formatetcOut: TFormatEtc): HResult;
    [PreserveSig]
    function SetData([in] var formatetc: TFormatEtc; var medium: TStgMedium;
      fRelease: BOOL): HResult;
    [PreserveSig]
    function EnumFormatEtc(dwDirection: Longint; out enumFormatEtc: IEnumFormatEtc): HResult;
    [PreserveSig]
    function DAdvise([in] var formatetc: TFormatEtc; advf: Longint;
      [in] var advSink: IAdviseSink; out dwConnection: Longint): HResult;
    [PreserveSig]
    function DUnadvise(dwConnection: Longint): HResult;
    [PreserveSig]
    function EnumDAdvise(out enumAdvise: IEnumStatData): HResult;
  end;

{ ISupportErrorInfo interface }

  [ComImport,
  GuidAttribute('DF0B3D60-548F-101B-8E65-08002B2BD119'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISupportErrorInfo = interface
    [PreserveSig]
    function InterfaceSupportsErrorInfo(
      [MarshalAs(UnmanagedType.LPStruct)] iid: TIID): HResult;
  end;

{ IOleWindow interface }

  [ComImport,
  GuidAttribute('00000114-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IOleWindow = interface
    [PreserveSig]
    function GetWindow(out wnd: HWnd): HResult;
    [PreserveSig]
    function ContextSensitiveHelp(fEnterMode: BOOL): HResult;
  end;

  [StructLayout(LayoutKind.Sequential)]
  tagOleMenuGroupWidths = record
    [MarshalAs(UnmanagedType.ByValArray, SizeConst = 6)]
    width: array[0..5] of Longint;
  end;
  TOleMenuGroupWidths = tagOleMenuGroupWidths;
  OLEMENUGROUPWIDTHS = TOleMenuGroupWidths;

const
{ from CGUID.H }
{ Standard GUIDs }

  GUID_NULL = '00000000-0000-0000-0000-000000000000';

{ from comcat.h }
{ COM Category Manager Interfaces }
type
  IEnumGUID = interface;
  IEnumCATEGORYINFO = interface;
  ICatRegister = interface;
  ICatInformation = interface;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  TCATEGORYINFO = record
    catid: TGUID;
    lcid: UINT;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
    szDescription: string;
  end;

  [ComImport,
  GuidAttribute('0002E000-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumGUID = interface
    [PreserveSig]
    function Next(celt: UINT; out rgelt: TGUID; out pceltFetched: UINT): HResult;
    [PreserveSig]
    function Skip(celt: UINT): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out ppenum: IEnumGUID): HResult;
  end;

  [ComImport,
  GuidAttribute('0002E011-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumCATEGORYINFO = interface
    [PreserveSig]
    function Next(celt: UINT; out rgelt: TCATEGORYINFO; out pceltFetched: UINT): HResult;
    [PreserveSig]
    function Skip(celt: UINT): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out ppenum: IEnumCATEGORYINFO): HResult;
  end;

  [ComImport,
  GuidAttribute('0002E012-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICatRegister = interface
    [PreserveSig]
    function RegisterCategories(cCategories: UINT; const rgCategoryInfo: TCATEGORYINFO): HResult;
    [PreserveSig]
    function UnRegisterCategories(cCategories: UINT;
      [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function RegisterClassImplCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function UnRegisterClassImplCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function RegisterClassReqCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
    [PreserveSig]
    function UnRegisterClassReqCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cCategories: UINT; [MarshalAs(UnmanagedType.LPStruct)] rgcatid: TGUID): HResult;
  end;

  [ComImport,
  GuidAttribute('0002E013-0000-0000-C000-000000000046'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ICatInformation = interface
    [PreserveSig]
    function EnumCategories(lcid: UINT; out ppenumCategoryInfo: IEnumCATEGORYINFO): HResult;
    [PreserveSig]
    function GetCategoryDesc([MarshalAs(UnmanagedType.LPStruct)] rcatid: TGUID;
      lcid: UINT; out pszDesc: string): HResult;
    [PreserveSig]
    function EnumClassesOfCategories(cImplemented: UINT;
      [in, MarshalAs(UnmanagedType.LPArray)] rgcatidImpl: array of TGUID;
      cRequired: UINT; rgcatidReq: IntPtr; out ppenumClsid: IEnumGUID): HResult;
    [PreserveSig]
    function IsClassOfCategories([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      cImplemented: UINT; [in, MarshalAs(UnmanagedType.LPArray)] rgcatidImpl: array of TGUID;
      cRequired: UINT; [in, MarshalAs(UnmanagedType.LPArray)] rgcatidReq: array of TGUID): HResult;
    [PreserveSig]
    function EnumImplCategoriesOfClass([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      out ppenumCatid: IEnumGUID): HResult;
    [PreserveSig]
    function EnumReqCategoriesOfClass([MarshalAs(UnmanagedType.LPStruct)] rclsid: TGUID;
      out ppenumCatid: IEnumGUID): HResult;
  end;

const
  CLSID_StdComponentCategoryMgr = '0002E005-0000-0000-C000-000000000046';

{ Init/Uninit }

const
  // flags passed as the coInit parameter to CoInitializeEx.
  COINIT_MULTITHREADED      = 0;      // OLE calls objects on any thread.
  COINIT_APARTMENTTHREADED  = 2;      // Apartment model
  COINIT_DISABLE_OLE1DDE    = 4;      // Dont use DDE for Ole1 support.
  COINIT_SPEED_OVER_MEMORY  = 8;      // Trade memory for speed.

function CoInitialize(pvReserved: IntPtr): HResult;
procedure CoUninitialize;
function CoInitializeEx(pvReserved: IntPtr; coInit: Longint): HResult;
{ Helper for creating instances }

function CoCreateInstance([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  dwClsContext: Longint; [MarshalAs(UnmanagedType.LPStruct)] iid: TIID;
  [MarshalAs(UnmanagedType.Interface)] out pv): HResult;

function CoCreateInstanceEx([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  [MarshalAs(UnmanagedType.IUnknown)] unkOuter: TObject;
  dwClsCtx: Longint; [in] var ServerInfo: TCoServerInfo;
  dwCount: Longint; [in, out] rgmqResults: TMultiQIArray): HResult;

function ProgIDFromCLSID([MarshalAs(UnmanagedType.LPStruct)] clsid: TCLSID;
  out pszProgID: IntPtr {POleStr}): HResult;
function CLSIDFromProgID(pszProgID: IntPtr; out clsid: TCLSID): HResult;
function SafeArrayCreate(vt: TVarType; cDims: Integer; [in] rgsabound: array of Integer): PSafeArray;
function SafeArrayDestroy(psa: PSafeArray): HResult;
function SafeArrayGetUBound(psa: PSafeArray; nDim: Integer; out lUbound: Longint): HResult;
function SafeArrayAccessData(psa: PSafeArray; out pvData: IntPtr): HResult;
function SafeArrayUnaccessData(psa: PSafeArray): HResult;

implementation

const
  ole32    = 'ole32.dll';
  oleaut32 = 'oleaut32.dll';
  olepro32 = 'olepro32.dll';

{ Externals from ole32.dll }
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CoInitialize')]
function CoInitialize; external;
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CoInitializeEx')]
function CoInitializeEx; external;
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CoUninitialize')]
procedure CoUninitialize; external;
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CoCreateInstance')]
function CoCreateInstance; external;
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CoCreateInstanceEx')]
function CoCreateInstanceEx; external;
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ProgIDFromCLSID')]
function ProgIDFromCLSID; external;
[DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CLSIDFromProgID')]
function CLSIDFromProgID; external;
[DllImport(oleaut32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SafeArrayCreate')]
function SafeArrayCreate; external;
[DllImport(oleaut32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SafeArrayDestroy')]
function SafeArrayDestroy; external;
[DllImport(oleaut32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SafeArrayGetUBound')]
function SafeArrayGetUBound; external;
[DllImport(oleaut32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SafeArrayAccessData')]
function SafeArrayAccessData; external;
[DllImport(oleaut32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SafeArrayUnaccessData')]
function SafeArrayUnaccessData; external;

{ Helper functions }

function Succeeded(Res: HResult): Boolean;
begin
  Result := Res and $80000000 = 0;
end;

function Failed(Res: HResult): Boolean;
begin
  Result := Res and $80000000 <> 0;
end;

end.
